# radio-symbol [![NPM version](https://img.shields.io/npm/v/radio-symbol.svg?style=flat)](https://www.npmjs.com/package/radio-symbol) [![NPM monthly downloads](https://img.shields.io/npm/dm/radio-symbol.svg?style=flat)](https://npmjs.org/package/radio-symbol) [![NPM total downloads](https://img.shields.io/npm/dt/radio-symbol.svg?style=flat)](https://npmjs.org/package/radio-symbol) [![Linux Build Status](https://img.shields.io/travis/enquirer/radio-symbol.svg?style=flat&label=Travis)](https://travis-ci.org/enquirer/radio-symbol) [![Windows Build Status](https://img.shields.io/appveyor/ci/enquirer/radio-symbol.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/enquirer/radio-symbol)

> Unicode radio button symbol, for toggling on/off in prompts.

## Table of Contents

- [Install](#install)
- [Styles](#styles)
- [Usage](#usage)
  * [Circle symbol](#circle-symbol)
  * [Ballot symbol](#ballot-symbol)
  * [Star symbol](#star-symbol)
- [About](#about)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save radio-symbol
```

## Styles

Have an idea for another radio-symbol style? [Pull requests](../../issues) greatly appreciated!

## Usage

* All of the `off` states are unstyled.
* All of the `on` states are styled using [ansi green](https://github.com/jonschlinkert/ansi-green).
* All of the `disabled` states are styled using [ansi gray](ansi-gray).

**Unstyled**

A `.nocolor` property is exposed with all states unstyled:

```js
var radio = require('radio-symbol').nocolor;
```

### Circle symbol

The main export is a circle. This is the only symbol that has a windows-specific alternative.

_(I haven't tested the star or ballot symbols on windows, if you try them [let us know](../../issues/new) if they have issues!)._

```js
var radio = require('radio-symbol');
console.log(radio.on);
//=> '◉'

console.log(radio.off);
//=> '◯'

console.log(radio.disabled);
//=> 'ⓧ'
```

**Windows**

```js
console.log(radio.on);
//=> '(*)'

console.log(radio.off);
//=> '( )'

console.log(radio.disabled);
//=> '(x)'
```

### Ballot symbol

```js
var radio = require('radio-symbol');
console.log(radio.ballot.on);
//=> '☑'

console.log(radio.ballot.off);
//=> '☐

console.log(radio.ballot.disabled);
//=> '☒' 
```

### Star symbol

```js
var radio = require('radio-symbol');
console.log(radio.star.on);
//=> '★'

console.log(radio.star.off);
//=> '☆'

console.log(radio.star.disabled);
//=> '☆' // same as "off"
```

## About

### Related projects

* [error-symbol](https://www.npmjs.com/package/error-symbol): Cross-platform error symbol. | [homepage](https://github.com/jonschlinkert/error-symbol "Cross-platform error symbol.")
* [info-symbol](https://www.npmjs.com/package/info-symbol): Cross-platform info symbol. | [homepage](https://github.com/jonschlinkert/info-symbol "Cross-platform info symbol.")
* [success-symbol](https://www.npmjs.com/package/success-symbol): Cross-platform success symbol. | [homepage](https://github.com/jonschlinkert/success-symbol "Cross-platform success symbol.")
* [warning-symbol](https://www.npmjs.com/package/warning-symbol): Cross-platform warning symbol. | [homepage](https://github.com/jonschlinkert/warning-symbol "Cross-platform warning symbol.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 21, 2017._